import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, create_zeros_array, create_dataframe, check_elements_in_list, iterate_rows, access_dataframe_loc, update_dataframe_loc

atp_tennis = read_csv_file('atp_tennis.csv')

# Assuming grass_matches and top_10_player_names are already defined
head_to_head_array = create_zeros_array((10, 10))
head_to_head_matrix = create_dataframe(head_to_head_array, columns=top_10_player_names, index=top_10_player_names)

# Filter grass matches where both players are in the top 10
head_to_head_matches = grass_matches[(check_elements_in_list(grass_matches['Player_1'], top_10_player_names)) & (check_elements_in_list(grass_matches['Player_2'], top_10_player_names))]

# Iterate over filtered matches, updating the head-to-head matrix with the winner and loser of each match
for index, row in iterate_rows(head_to_head_matches):
	winner = row['Winner']
	loser = row['Player_1'] if row['Player_1'] != winner else row['Player_2']
	current_value = access_dataframe_loc(head_to_head_matrix, winner, loser)
	update_dataframe_loc(head_to_head_matrix, winner, loser, current_value + 1)

print(head_to_head_matrix)
pickle.dump(head_to_head_matrix,open("./ref_result/head_to_head_matrix.pkl","wb"))